import { a6d28777ab56c8416 } from "../internal/aa89649a981b0bfc2/a6d28777ab56c8416";
import { StarIO10Error, StarIO10ArgumentError, StarIO10AuthenticationError, StarIO10BadResponseError, StarIO10CommunicationError, StarIO10ErrorMessage, StarIO10IllegalDeviceStateError, StarIO10InUseError, StarIO10InvalidOperationError, StarIO10NotFoundError, StarIO10ServerCommunicationError, StarIO10UnknownError, StarIO10UnprintableError, StarIO10UnsupportedModelError, StarIO10ErrorCode, } from ".";
import { a341439e4e686906a } from "../internal/acf0e9bfb1cb9236c/a341439e4e686906a";
/* eslint-disable @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-argument, @typescript-eslint/no-unsafe-member-access */
export class StarIO10ErrorFactory {
    //StarIO10Error.generalize()で変換されたErrorを元のStarIO10Errorに戻す。
    static degeneralize(error) {
        try {
            const map = JSON.parse(error.message);
            const typeName = map["type"] ?? "StarIO10Error";
            const message = map["message"] ?? StarIO10ErrorMessage.UnknownError.message;
            const statusString = map["status"] ?? "";
            const errorCode = map["errorCode"] ?? StarIO10ErrorCode.None;
            switch (typeName) {
                case "StarIO10ArgumentError": {
                    const argumentError = new StarIO10ArgumentError(message, errorCode);
                    argumentError.stack = error.stack;
                    return argumentError;
                }
                case "StarIO10AuthenticationError": {
                    const authError = new StarIO10AuthenticationError(message, errorCode);
                    authError.stack = error.stack;
                    return authError;
                }
                case "StarIO10BadResponseError": {
                    const badResponseError = new StarIO10BadResponseError(message, errorCode);
                    badResponseError.stack = error.stack;
                    return badResponseError;
                }
                case "StarIO10CommunicationError": {
                    const commError = new StarIO10CommunicationError(message, errorCode);
                    commError.stack = error.stack;
                    return commError;
                }
                case "StarIO10IllegalDeviceStateError": {
                    const illegalStateError = new StarIO10IllegalDeviceStateError(message, errorCode);
                    illegalStateError.stack = error.stack;
                    return illegalStateError;
                }
                case "StarIO10InUseError": {
                    const inUseError = new StarIO10InUseError(message, errorCode);
                    inUseError.stack = error.stack;
                    return inUseError;
                }
                case "StarIO10InvalidOperationError": {
                    const invalidOperationError = new StarIO10InvalidOperationError(message, errorCode);
                    invalidOperationError.stack = error.stack;
                    return invalidOperationError;
                }
                case "StarIO10NotFoundError": {
                    const notFoundError = new StarIO10NotFoundError(message, errorCode);
                    notFoundError.stack = error.stack;
                    return notFoundError;
                }
                case "StarIO10ServerCommunicationError": {
                    const serverCommError = new StarIO10ServerCommunicationError(message, errorCode);
                    serverCommError.stack = error.stack;
                    return serverCommError;
                }
                case "StarIO10UnknownError": {
                    const unknownError = new StarIO10UnknownError(message, errorCode);
                    unknownError.stack = error.stack;
                    return unknownError;
                }
                case "StarIO10UnprintableError": {
                    let status = undefined;
                    try {
                        status = a341439e4e686906a.deserialize(statusString).status;
                    }
                    catch {
                        //何もしない
                    }
                    const unprintableError = new StarIO10UnprintableError(message, errorCode, status);
                    unprintableError.stack = error.stack;
                    return unprintableError;
                }
                case "StarIO10UnsupportedModelError": {
                    const unsupportedModelError = new StarIO10UnsupportedModelError(message, errorCode);
                    unsupportedModelError.stack = error.stack;
                    return unsupportedModelError;
                }
                default: {
                    const stario10Error = new StarIO10Error(message, errorCode);
                    stario10Error.stack = error.stack;
                    return stario10Error;
                }
            }
        }
        catch {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return throwE;
        }
    }
}
